import React,{useState, useEffect} from 'react';
import {Form, Upload, Spin, message, Modal, Button, Input, notification} from "antd";
import {PlusOutlined} from "@ant-design/icons";
import axios from 'axios';
import env from "../env";

const Restaurant = props => {
    const [loadingSave, setLoadingSave] = useState(false);
    const [loadingLoad, setLoadingLoad] = useState(true);
    const [restaurant, setRestaurant] = useState({});

    useEffect(()=> {
        setLoadingLoad(true);
        getRestaurant()
    },[])

    const getRestaurant = () => {
        axios.get(env.api + 'Restaurants').then(res=>{
            setRestaurant(res.data);
            setLoadingLoad(false);
            setLoadingSave(false);
        });
    }
    const beforeUpload = (file) => {
        const isJpgOrPng = file.type === 'image/jpeg' || file.type === 'image/png';
        if (!isJpgOrPng) {
            message.error('Сликата мора да е формат jpg или png');
        }
        if(isJpgOrPng) setLoadingSave(true);
        return isJpgOrPng;
    }
    const uploadChanged = (ev) =>{
        if(ev.file.status == 'done'){
            getRestaurant()
        }
    }
    const submitEdit = (form) => {
        setLoadingSave(true);
        axios.put(env.api + 'Restaurants/',{...form}, { headers: {Authorization: localStorage.getItem('Auth')}
        }).then(res => {
            notification['success']({
                message: 'Успешно зачувано',
            });
            setLoadingSave(false);
        }).catch(er => {
            notification['error']({
                message: 'Се случи проблем при менување контакт информации. Ве молиме пробајте повторно подоцна',
            });
            setLoadingSave(false);
            console.log(er);
        })
        console.log(form)
    }
    return(
        <div style={{padding:'20px'}}>
            <div style={{backgroundColor:'white'}}>
                <div style={{
                    width: '100%',
                    height:'75px',
                    backgroundColor: 'white',
                    padding: '20px',
                    border: '1px solid lightgray'
                }} >
                    <h2 style={{float: 'left'}}>Ресторан</h2>
                </div>
                {loadingLoad ? <Spin size="large"/> :
                    <div style={{padding:'20px'}}>
                        <Upload
                            name="file"
                            onChange={uploadChanged}
                            showUploadList={false}
                            beforeUpload={beforeUpload}
                            style={{maxWidth: '90%', height: '200px', overflow: 'hidden'}}
                            action={env.api+'Restaurants/upload'}
                        >
                            {restaurant.base64Image != "data:image/png;base64," ? <img style={{cursor: 'pointer'}} src={restaurant.base64Image} alt="avatar"
                                                      height='200px'/> : <div style={{cursor:'pointer',margin: 15,border:'1px solid gray',padding: 5}}><PlusOutlined /><div style={{ marginTop: 8}}>Додади слика</div></div>}
                        </Upload>
                        <div style={{textAlign: 'start', width: '100%', marginTop:'10px'}}>
                            <Form onFinish={submitEdit}
                                  onFinishFailed={() => Modal.error({title: "Ве молиме пополнете ги задолжителните полиња"})}
                                  initialValues={{...restaurant}}>
                                <Form.Item
                                    label="Име на локал"
                                    name="name"

                                    rules={[
                                        {
                                            required: true,
                                            message: 'Ве молиме внесете име на локалот!',
                                        },
                                    ]}
                                >
                                    <Input/>
                                </Form.Item>
                                <Form.Item
                                    label="Адреса"
                                    name="address"
                                    rules={[
                                        {
                                            required: true,
                                            message: 'Ве молиме внесете адреса!',
                                        },
                                    ]}
                                >
                                    <Input/>
                                </Form.Item>
                                <Form.Item
                                    label="Телефон"
                                    name="phone"
                                    rules={[
                                        {
                                            required: true,
                                            message: 'Ве молиме внесете телефон!',
                                        },
                                    ]}
                                >
                                    <Input placeholder='ex. 070123456'/>
                                </Form.Item>
                                <Form.Item style={{textAlign: 'center'}}>
                                    <Button type="primary" htmlType="submit" loading={loadingSave}>
                                        Зачувај
                                    </Button>
                                </Form.Item>
                            </Form>
                        </div>
                    </div>
                }
            </div>
        </div>
    )
}
export default Restaurant;