﻿namespace backend.Controllers;

using backend.DTOs;
using backend.Entities;
using backend.Helpers;
using backend.Models;
using backend.Services;
using Microsoft.AspNetCore.Mvc;
using System.Security.Claims;

[ApiController]
[Route("[controller]")]
public class ToDoController : ControllerBase
{
    private readonly IToDoService _toDoService = null;

    public ToDoController(IToDoService todoService)
    {
        _toDoService = todoService;
    }

    [Authorize]
    [HttpPost()]
    public async Task<IActionResult> CreateToDoItem([FromBody] CreateToDoItemRequest req)
    {
        await _toDoService.AddNewToDoItem(req);
        return Ok();
    }

    [Authorize]
    [HttpGet()]
    public async Task<List<ToDoItemResponse>> GetToDoItems(string sortBy)
    {
        return await _toDoService.GetToDoItems(sortBy);
    }

    [Authorize]
    [HttpPut("{id}")]
    public async Task<IActionResult> UpdateToDoStatus(int id, ToDoStatus newStatus)
    {
        await _toDoService.UpdateToDoItemStatus(id, newStatus);
        return Ok();
    }
}
