﻿namespace backend.Controllers;

using backend.DTOs;
using backend.Entities;
using backend.Helpers;
using backend.Models;
using backend.Services;
using Microsoft.AspNetCore.Mvc;
using System.Security.Claims;

[ApiController]
[Route("[controller]")]
public class MenuController : ControllerBase
{
    private readonly IMenuService _menuService = null;

    public MenuController(IMenuService menuService)
    {
        _menuService = menuService;
    }

    [Authorize]
    [HttpPost()]
    public async Task<IActionResult> CreateMenuItem([FromBody] CreateMenuItemRequest req)
    {
        await _menuService.AddMenu(req);
        return Ok();
    }

    [Authorize]
    [HttpDelete("{id}")]
    public async Task<IActionResult> DeleteMenuItem(int id)
    {
        await _menuService.RemoveMenu(id);
        return Ok();
    }
}
