import React, {useState, useEffect} from 'react'
import {Header} from "./Header";
import {useNavigate} from "react-router-dom";
import {Button, Card, Image, Modal, Spin} from "antd";
import placeholderImage from '../src/Assets/placeholder.png'
import AddNewReservation from "./Dashboard/AddNewReservation";
import axios from "axios";
import env from "./env";

const FrontPage = ({}) => {
    const [restaurant, setRestaurant] = useState({name:'Sample Restaurant name', address: 'Sample street 1', city:'Sample'});
    const [newReservationModal, setNewReservationModal] = useState(false);
    const [saveModalLoading, setSaveModalLoading] = useState(false);
    const [loading, setLoading] = useState(true);
    const history = useNavigate();

    useEffect(()=>{
        setLoading(true);
        axios.get(env.api + 'Restaurants').then(res=>{
            setRestaurant(res.data);
            setLoading(false);
        });
    },[])

    return(
        <div>
            <Header onClickButton={()=>history('/login')} buttonText={'Логирај се'}/>
            {loading ? <Spin style={{margin: 20}}/> :
                <div style={{
                    height: '400px',
                    width: '100%',
                    borderTop: '1px solid gray',
                    padding: '20px'
                }}>
                    <div id={'businessFrontImage'}>
                        <Image
                            src={restaurant.base64Image}
                            id={'businessFrontInsideImage'}
                            placeholder={
                                <img
                                    src={placeholderImage}
                                    alt={'place'}
                                    style={{width: '100%', height: '100%'}}
                                />
                            }
                            wrapperStyle={{overflow: 'hidden', width: '100%'}}
                            style={{width: '100%', height: '100%', margin: 'auto', objectFit: 'cover'}}>
                        </Image>
                    </div>
                    <div id={'businessFrontInfo'}>
                        <div style={{
                            width: '100%',
                            height: '100%',
                            display: 'flex',
                            flexDirection: 'column',
                            justifyContent: 'space-between'
                        }}>
                            <div style={{flexGrow: 1, fontSize: '20px', fontWeight: '500', textAlign: 'start'}}>
                                {restaurant.name}
                                <div style={{
                                    color: 'gray',
                                    fontSize: '10px'
                                }}>{restaurant.address}, {restaurant.phone}</div>
                            </div>
                            <Button onClick={() => setNewReservationModal(true)}
                                    style={{width: '100%', marginTop: '5px'}} type={'primary'}>Резервирај</Button>
                        </div>

                    </div>
                    <div style={{textAlign: 'start', backgroundColor: '#F2F2F2'}}>
                        <h2 style={{textAlign:'center',paddingTop:'20px'}}>Мени</h2>
                        {restaurant.menu.map(el =>
                            <Card title={el.title} style={{ width: 280, display:'inline-block', margin:'10px' }} size="small">
                                <p>{el.description}</p>
                                <b>{el.price} ден.</b>
                            </Card>
                        )}
                    </div>
                </div>
            }
            <Modal
                style={{top: 20}}
                width={'700px'}
                title="Нова Резервација"
                footer={[
                    <Button form="newResForm" key="submit" htmlType="submit" type={'primary'} loading={saveModalLoading}>
                        Прати
                    </Button>
                ]}
                onCancel={()=>setNewReservationModal(false)}
                visible={newReservationModal}>
                <AddNewReservation setModalSaveLoading={setSaveModalLoading} setModalVisible={setNewReservationModal} />
            </Modal>
        </div>

    )
}

export default FrontPage;