import React,{useState,useEffect} from 'react'
import {DatePicker, Form, Input, Modal, notification, Radio, Select} from "antd";
import axios from "axios";
import env from "../env";

const AddNewReservation = ({ setModalSaveLoading, setModalVisible, fetchData}) => {

    const saveNewReservation = (data) => {
        setModalSaveLoading(true)
        const sendObj = {...data,startDate: data.startDate.format('YYYY-MM-DDThh:mm:ss')+'Z', persons: parseInt(data.persons)}
        console.log(sendObj)
        axios.post(env.api+"Reservations",sendObj).then(el => {
            setModalSaveLoading(false)
            setModalVisible(false)
            if(fetchData) fetchData()
            Modal.success({title:'Испратено', content:'Вашата резервација е испратена.'})
        }).catch(er=>{
            setModalSaveLoading(false)
            notification['error']({
                message: 'Се случи проблем при додавање резервација. Ве молиме пробајте повторно подоцна',
            });

            console.log(er);
        });
    }


    return(
        <div>
            <Form onFinish={saveNewReservation}
                  id={'newResForm'}
                  onFinishFailed={()=>
                      notification['error']({
                          message: 'Ве молиме поправете ги сите грешки пред зачувување!',
                      })}>
                <i style={{color:'gray'}}>Датум и време за вашата резервација</i>
                <Form.Item
                    label="Почеток"
                    name="startDate"
                    rules={[
                        {
                            required: true,
                            message: 'Ве молиме внесете датум и време!',
                        },
                    ]}
                >
                    <DatePicker showTime showNow={false} format={'DD.MM HH:mm'} placeholder={'Избери датум и време'} style={{width:'100%'}}/>
                </Form.Item>
                <i style={{color:'gray'}}>Внесете број на гости за резервацијата</i>
                <Form.Item
                    label="Број на гости"
                    name="persons"
                    rules={[
                        {
                            required: true,
                            message: 'Ве молиме внесете број на гости!',
                        },
                    ]}
                >
                    <Input placeholder={'Внесете број'} type={'number'}/>
                </Form.Item>
                <i style={{color:'gray'}}>Изберете место и тип на резервација</i>
                <Form.Item
                    label="Место"
                    name="reservationPlace"
                    rules={[
                        {
                            required: true,
                            message: 'Ве молиме изберете место!',
                        },
                    ]}
                >
                    <Select>
                        <Select.Option value={0}>Внатре</Select.Option>
                        <Select.Option value={1}>Надвор</Select.Option>
                    </Select>
                </Form.Item>
                <Form.Item
                    label="Тип"
                    name="reservationType"
                    rules={[
                        {
                            required: true,
                            message: 'Ве молиме изберете тип!',
                        },
                    ]}
                >
                    <Select>
                        <Select.Option value={0}>Кратко</Select.Option>
                        <Select.Option value={1}>Долго</Select.Option>
                        <Select.Option value={2}>Настан</Select.Option>
                    </Select>
                </Form.Item>
                <i style={{color:'gray'}}>Контакт информации</i>
                <Form.Item
                    label="Име"
                    name="contactName"
                    rules={[
                        {
                            required: true,
                            message: 'Ве молиме внесете име!',
                        },
                    ]}
                >
                    <Input/>
                </Form.Item>
                <Form.Item
                    label="Телефонски број"
                    name="contactNumber"
                    rules={[
                        {
                            required: true,
                            message: 'Ве молиме внесете број за контакт!',
                        },
                    ]}
                >
                    <Input placeholder={'пр. 070123456'}/>
                </Form.Item>

            </Form>
        </div>
    )
}

export default AddNewReservation;