import React, {useState} from 'react'
import {Header} from "./Header";
import {useNavigate} from "react-router-dom";
import {Button, Image, Modal} from "antd";
import placeholderImage from '../src/Assets/placeholder.png'
import AddNewReservation from "./Dashboard/AddNewReservation";

const FrontPage = ({}) => {
    const [restaurant, setRestaurant] = useState({name:'Sample Restaurant name', address: 'Sample street 1', city:'Sample'});
    const [newReservationModal, setNewReservationModal] = useState(false);
    const [saveModalLoading, setSaveModalLoading] = useState(false);
    const history = useNavigate();
    return(
        <div>
            <Header onClickButton={()=>history('/login')} buttonText={'Логирај се'}/>
                <div style={{
                    height: '400px',
                    width: '100%',
                    borderTop: '1px solid gray',
                    padding: '20px'
                }}>
                <div id={'businessFrontImage'}>
                    <Image
                        src={restaurant.photo}
                        id={'businessFrontInsideImage'}
                        placeholder={
                            <img
                                src={placeholderImage}
                                alt={'place'}
                                style={{width:'100%',height:'100%'}}
                            />
                        }
                        wrapperStyle={{overflow:'hidden',width:'100%'}}
                        style={{width:'100%', height:'100%',margin: 'auto',objectFit:'cover'}}>
                    </Image>
                </div>
                <div id={'businessFrontInfo'} >
                    <div style={{width:'100%',height:'100%',display:'flex',flexDirection:'column',justifyContent:'space-between'}}>
                        <div style={{flexGrow:1, fontSize:'20px', fontWeight:'500', textAlign:'start'}}>
                            {restaurant.name}
                            <div style={{color:'gray',fontSize:'10px'}}>{restaurant.address}, {restaurant.city}</div>
                        </div>
                        <Button onClick={()=>setNewReservationModal(true)} style={{width:'100%',marginTop:'5px'}} type={'primary'}>Резервирај</Button>
                    </div>

                </div>
            </div>
            <Modal
                style={{top: 20}}
                width={'700px'}
                title="Нова Резервација"
                footer={[
                    <Button form="newResForm" key="submit" htmlType="submit" type={'primary'} loading={saveModalLoading}>
                        Прати
                    </Button>
                ]}
                onCancel={()=>setNewReservationModal(false)}
                visible={newReservationModal}>
                <AddNewReservation setModalSaveLoading={setSaveModalLoading} setModalVisible={setNewReservationModal} />
            </Modal>
        </div>

    )
}

export default FrontPage;