﻿namespace backend.Controllers;

using backend.DTOs;
using backend.Entities;
using backend.Helpers;
using backend.Models;
using backend.Services;
using Microsoft.AspNetCore.Mvc;

[ApiController]
[Route("[controller]")]
public class UsersController : ControllerBase
{
    private readonly IUserService _userService = null;

    public UsersController(IUserService userService)
    {
        _userService = userService;
    }

    [HttpPost("login")]
    public async Task<AuthenticateResponse> Authenticate(AuthenticateRequest model)
    {
        var response = await _userService.Authenticate(model);

        if (response == null)
            throw new Exception("Email or password is incorrect");

        return response;
    }

    [HttpGet("authed")]
    public async Task<AuthenticateResponse> IsAuthed()
    {
        int userId = 0;
        try
        {
            userId = (int)this.HttpContext.Items["User"];
        }catch (Exception ex){ return null; }
        User user = await _userService.GetById(userId);
        return new AuthenticateResponse() { Email=user.Email, Id = user.Id};
    }

    [HttpPost("register")]
    public async Task<AuthenticateResponse> Register(CreateUserRequest req)
    {
        var response = await _userService.Register(req);
        return response;
    }
}
