﻿using backend.Data;
using backend.DTOs;
using backend.Entities;
using Microsoft.EntityFrameworkCore;

namespace backend.Services
{
    public interface IRestaurantService
    {
        public Task CreateRestaurant(string name, int userId);
        public Task<RestaurantResponse> GetRestaurant();
    }
    public class RestaurantService : IRestaurantService
    {
        private readonly DataContext _context = null;

        public RestaurantService(DataContext context)
        {
            _context = context;
        }
        public async Task CreateRestaurant(string name, int userId)
        {
            User user = await _context.Users.FindAsync(userId);
            Restaurant restaurant = new Restaurant() { Name = name, Owner = user};
            await _context.Restoraunts.AddAsync(restaurant);
            await _context.SaveChangesAsync();
        }

        public async Task<RestaurantResponse> GetRestaurant()
        {
            RestaurantResponse res = await _context.Restoraunts
                .Select(x => new RestaurantResponse()
                {
                    Id = x.Id,
                    Name = x.Name,
                    OwnerId = x.OwnerFk,
                })
                .FirstOrDefaultAsync();
            return res;
        }
    }
}
