import React, {useEffect, useState} from 'react'
import {
    Button,
    Card,
    DatePicker,
    Dropdown,
    Form,
    Input,
    List, Menu,
    Modal,
    notification,
    Rate,
    Select, Space,
    Spin,
    Tooltip
} from "antd";
import moment from "moment";
import axios from "axios";
import env from "../env";
import AddNewReservation from "./AddNewReservation";
import {DownOutlined} from "@ant-design/icons";

const ToDo = ({}) => {

    const [loading, setLoading] = useState(true);
    const [todoItems, setToDoItems] = useState([]);
    const [newTodoVisible, setNewTodoVisible] = useState(false);
    const [saveNewTodoLoading, setSaveNewTodoLoading] = useState(false)
    const [restaurant, setRestaurant] = useState({reviews:[]})
    const [showReview, setShowReview] = useState(null);
    const [sortSelect, setSortSelect] = useState('date')

    useEffect(()=> {
        setLoading(true);
        getToDos()
        getRestaurant()
    },[])

    const getToDos = () => {
        setSortSelect(type=> {
            axios.get(env.api + 'ToDo', {
                params: {sortBy: type},
                headers: {Authorization: localStorage.getItem('Auth')}
            }).then(res => {
                console.log(res.data)
                setToDoItems(res.data);
                setLoading(false);
            });
            return type
        })
    }

    const updateSort = (type)=>{
        setSortSelect(type);
        getToDos();
    }

    const createToDo = (data) => {
        console.log(data)
        setSaveNewTodoLoading(true);
        axios.post(env.api + 'ToDo', data, {headers:{Authorization:localStorage.getItem('Auth')}}).then(res=>{
            setSaveNewTodoLoading(false);
            setNewTodoVisible(false);
            getToDos()
        });
    }


    const getRestaurant = () => {
        axios.get(env.api + 'Restaurants').then(res=>{
            setRestaurant(res.data);
            setLoading(false);
        });
    }

    const changeStatus = (id, newStatus) => {
        axios.put(env.api + 'ToDo/'+id, {}, {params:{newStatus:newStatus}, headers:{Authorization:localStorage.getItem('Auth')}}).then(res=>{
            getToDos()
        });
    }

    return(
        <div style={{padding: '20px',textAlign:'center'}}>
            <div style={{
                width: '100%',
                backgroundColor: 'white',
                padding: '20px',
                height:'75px',
                border: '1px solid lightgray'
            }} id={'expandMain'}>
                <h2 style={{float: 'left'}}>ToDo листа</h2>
                <Button style={{float:'right'}} type={'primary'} onClick={()=>setNewTodoVisible(true)}>Внеси нов запис</Button>
                <div style={{float:'right', marginRight:'20px'}}>
                    <span style={{marginRight:'5px'}}>Начин на подредување:</span>
                    <Select
                        defaultValue="date"
                        style={{
                            width: 120,
                        }}
                        onChange={(el)=>updateSort(el)}
                    >
                        <Select.Option value="date">Датум</Select.Option>
                        <Select.Option value="priority">Приоритет</Select.Option>
                    </Select>
                </div>
            </div>
            {loading ? <Spin style={{margin: '20px', textAlign:'center'}}/> :
                <div style={{textAlign:'start'}}>
                    <List dataSource={todoItems} itemLayout={'horizontal'} locale={{emptyText:'Немате направено ToDo'}}
                          renderItem={item => (
                              <Card title={item.title} style={{width:'98%',backgroundColor:'white',margin:'1%'}}
                                    actions={
                                      item.status == 0 ?
                                          [<a style={{color:'#1890ff'}} onClick={()=>changeStatus(item.id,1)}>Започни</a>, <a style={{color:'red'}} onClick={()=>changeStatus(item.id,3)}>Отфрли</a>]
                                          : item.status == 1 ? [<a style={{color:'green'}} onClick={()=>changeStatus(item.id,2)}>Заврши</a>, <a style={{color:'red'}} onClick={()=>changeStatus(item.id,3)}>Отфрли</a>]
                                          : []}
                                    extra={<div style={{textAlign:'end'}}>
                                            {
                                                item.status == 0 ? [<span style={{color:'#1890ff'}}>Ново</span>] :
                                                    item.status == 1 ? [<span style={{color:'orange'}}>Започнато</span>] :
                                                item.status == 2 ? [<span style={{color:'green'}}>Завршено</span>] :
                                                    item.status == 3 ? [<span style={{color:'red'}}>Отфрлено</span>] : ''
                                            }
                                            <br/>
                                            <span style={{color:'gray'}}>{moment(item.createdAt).format("DD.MM.yyyy")}</span>
                                        </div>}
                                    >
                                  <p>{item.description}</p>
                                  <div style={{borderTop:'1px solid rgb(242, 242, 242)', marginBottom:'15px'}}/>
                                  <span style={{float:'left'}}>{item.linkedReview ? <p onClick={() => setShowReview(item.linkedReview)}>Поврзана оценка: <span style={{textDecoration:'underline', cursor:'pointer'}}>{item.linkedReview.id +' - '+ item.linkedReview.title}</span></p> : <></>}</span>
                                  <span style={{float:'right'}}>Приоритет: {item.priority}</span>
                              </Card>
                          )}/>
                </div>

            }
            <Modal
                style={{top: 20}}
                width={'700px'}
                title="Нова ToDo"
                footer={[
                    <Button form="newToDoForm" key="submit" htmlType="submit" type={'primary'} loading={saveNewTodoLoading}>
                        Прати
                    </Button>
                ]}
                onCancel={()=>setNewTodoVisible(false)}
                visible={newTodoVisible}>
                <div>
                    <Form onFinish={createToDo}
                          id={'newToDoForm'}
                          onFinishFailed={()=>
                              notification['error']({
                                  message: 'Ве молиме поправете ги сите грешки пред зачувување!',
                              })}>
                        <Form.Item
                            label="Наслов"
                            name="title"
                            rules={[
                                {
                                    required: true,
                                    message: 'Ве молиме внесете наслов!',
                                },
                            ]}
                        >
                            <Input/>
                        </Form.Item>
                        <Form.Item
                            label="Опис"
                            name="description"
                            rules={[
                                {
                                    required: true,
                                    message: 'Ве молиме внесете опис!',
                                },
                            ]}
                        >
                            <Input.TextArea rows={4}/>
                        </Form.Item>
                        <Form.Item
                            label="Приоритет"
                            name="priority"
                            rules={[
                                {
                                    required: true,
                                    message: 'Ве молиме внесете приоритет!',
                                },
                                {
                                    regex:  new RegExp('^[1-9]\\d*$'),
                                    message: 'Ве молиме внесете позитивен број!',
                                },
                            ]}
                        >
                            <Input type={'number'}/>
                        </Form.Item>
                        <Form.Item
                            label="Поврзана оценка"
                            name="reviewId"
                        >
                            <Select>
                                {restaurant.reviews.map(el =>(
                                    <Select.Option value={el.id}>{el.id +" - "+ el.title}</Select.Option>
                                ))}
                            </Select>
                        </Form.Item>
                    </Form>
                </div>
            </Modal>
            <Modal
                style={{top: '10%', padding:'0'}}
                bodyStyle={{backgroundColor:'rgb(242, 242, 242)'}}
                width={'700px'}
                title="Поврзана оценка"
                footer={[
                    <Button onClick={()=>setShowReview(null)}>
                        Затвори
                    </Button>
                ]}
                onCancel={()=>setShowReview(null)}
                visible={showReview != null}>
                <div style={{backgroundColor:'rgb(242, 242, 242)'}}>
                    {showReview ?
                        <Card title={showReview.title} >
                            <p>{showReview.description}</p>
                            <Rate disabled value={showReview.stars}/>
                            <p style={{color: 'gray'}}>{moment(showReview.createdAt).format("DD.MM.yyyy")}</p>
                        </Card>
                    :<></>}
                </div>
            </Modal>
        </div>
    )
}
export default ToDo;
