import './App.css';
import {Route, BrowserRouter as Router, Navigate, Routes, useNavigate} from "react-router-dom";
import axios from 'axios'
import env from './env'
import { gapi } from 'gapi-script';

import {Spin} from "antd";
import React, {useEffect, useState} from "react";
import {Login, Register} from "./Auth/auth";
import Dashboard from "./Dashboard";
import Reservations from "./Dashboard/Reservations";
import FrontPage from "./FrontPage";
import Restaurant from "./Dashboard/Restaurant";
import Menu from "./Dashboard/Menu";
import Review from "./Dashboard/Review";
import Confirm from "./Auth/Confirm";
import SendConfirm from "./Auth/SendConfirm";
import SendReset from "./Auth/SendReset";
import Reset from "./Auth/Reset";
import ToDo from "./Dashboard/ToDo";
import Vip from "./Dashboard/Vip";


function App() {
  const [user, setUser] = useState(undefined)
  const [loading, setLoading] = useState(true)
  useEffect(()=>{
    getUser()
  },[])

  gapi.load('client:auth2', () => {
    gapi.client.init({
      clientId: '748923557453-ljii8ulhti93man769d2dd9soi7038j5.apps.googleusercontent.com',
      plugin_name: 'chat'
    });
  });

  const getUser = () => {
    setLoading(true)
    axios.get(env.api+'Users/authed',{headers:{Authorization:localStorage.getItem('Auth')}}).then(res=>{
      console.log(res.data)
      setUser(res.data)
      setLoading(false)
    })
  }
  const logout = () => {
    setUser(undefined);
    localStorage.removeItem('Auth');
    window.location.replace('/')
  }
  return (
    <div style={{textAlign:'center'}}>
      <Router>
          <Routes>
            <Route path="/dashboard" element={loading ? <Spin /> : user ? (user.isAdmin ? <Dashboard setUser={setUser}/> : <Navigate to="/" replace={true} />) :  <Navigate to="/login" replace={true} />}>
              <Route path="/dashboard" element={<Restaurant/>}/>
              <Route path="/dashboard/menu" element={<Menu/>}/>
              <Route path="/dashboard/reservations" element={<Reservations/>}/>
              <Route path="/dashboard/reviews" element={<Review/>}/>
              <Route path="/dashboard/todo" element={<ToDo/>}/>
              <Route path="/dashboard/vip" element={<Vip/>}/>
            </Route>
            <Route path="/login" element={loading ? <Spin /> :  !user ? <Login setUser={setUser}/> :  <Navigate to="/dashboard" replace={true} />}/>
            <Route path="/register" element={loading ? <Spin /> :  !user ? <Register setUser={setUser}/> :  <Navigate to="/dashboard" replace={true} />}/>
            <Route path="/reset-password" element={loading ? <Spin /> : <SendReset/>}/>
            <Route path="/reset" element={loading ? <Spin /> : <Reset/>}/>
            <Route path="/confirm" element={loading ? <Spin /> : <Confirm setUser={setUser} user={user}/>}/>
            <Route path="/confirm-email" element={loading ? <Spin /> : <SendConfirm setUser={setUser} user={user}/>}/>
            <Route path="/" element={<FrontPage user={user} logout={logout}/>}/>
          </Routes>
      </Router>
    </div>
  );
}

export default App;
