import React, {useState} from 'react'
import {useNavigate} from "react-router-dom";
import {Button, Card, Form, Input, Modal, notification} from "antd";
import { UserOutlined, LockOutlined } from '@ant-design/icons';
import axios from "axios";
import '../App.css'
import env from "../env";
import { GoogleLogin } from 'react-google-login';
import FacebookLogin from 'react-facebook-login';

const setAuthCookie = (token) => {
    localStorage.setItem('Auth','Bearer '+token)
}

const Login = ({setUser}) => {
    const history = useNavigate()

    const [loading, setLoading] = useState(false)

    const login = (attr) => {
        setLoading(true)
        axios.post(env.api+'Users/login',{email: attr.email, password: attr.password}).then(res => {
            setAuthCookie(res.data.token)
            console.log(res.data.token)
            setUser(res.data)
            setLoading(false)
            history(res.data.isAdmin ? '/dashboard' : '/')
        }).catch(el => {
            Modal.error({
                title: 'Погрешен мејл или лозинка',
            });
            setLoading(false)
        })
    }

    const googleLoginResponse = (response)=>{
        console.log(response)
        setLoading(true)
        console.log(response.tokenId)
        setAuthCookie('Bearer '+response.tokenId)
        axios.post(env.api+'Users/register',{email: response.profileObj.email, password:'', isConfirmed: true}).then(res => {
            setUser(res.data)
            setLoading(false)
            history(res.data.isAdmin ? '/dashboard' : '/')
        })
    }

    const facebookLoginResponse = (response) =>{
        console.log(response)
        setLoading(true)
        setAuthCookie('Bearer '+response.accessToken)
        axios.post(env.api+'Users/register',{email: response.email, password:'', isConfirmed: true}).then(res => {
            setUser(res.data)
            setLoading(false)
            history(res.data.isAdmin ? '/dashboard' : '/')
        })
    }

    return(
        <div style={{width:'100vw',height:'100vh', textAlign:'center',backgroundColor:'#F2F2F2'}}>
            <div className='center'>
                <Card style={{backgroundColor:'white', width:'100%', borderRadius:'20px'}} className='center'>
                    <h1>Најави се</h1>
                    <Form
                        name="normal_login"
                        onFinish={res=>login(res)}
                    >
                        <Form.Item
                            name="email"
                            rules={[
                                {
                                    required: true,
                                    message: 'Внесете мејл',
                                },
                                {
                                    type: 'email',
                                    message: 'Внесете валиден мејл',
                                },
                            ]}
                        >
                            <Input prefix={<UserOutlined className="site-form-item-icon" />} placeholder="Email" />
                        </Form.Item>
                        <Form.Item
                            name="password"
                            rules={[
                                {
                                    required: true,
                                    message: 'Внесете лозинка!',
                                }
                            ]}
                        >
                            <Input
                                prefix={<LockOutlined className="site-form-item-icon" />}
                                type="password"
                                placeholder="Password"
                            />
                        </Form.Item>

                        <Form.Item style={{margin:'0px'}}>
                            <Button type="primary" htmlType="submit" className="login-form-button" loading={loading} style={{marginBottom:'5px'}}>
                                Log in
                            </Button>
                            <br/>
                            <GoogleLogin
                                clientId="748923557453-ljii8ulhti93man769d2dd9soi7038j5.apps.googleusercontent.com"
                                buttonText="Логирај се со Google"
                                onSuccess={googleLoginResponse}
                            />
                            <FacebookLogin
                                appId="1455131645009417"
                                size={'small'}
                                textButton={'Логирај се со FB'}
                                icon="fa-facebook"
                                fields="name,email"
                                callback={facebookLoginResponse} />
                            <div>
                                Или <a href={"/register"}>регистрирај се!</a>
                            </div>
                            <div>
                                <a href={"/reset-password"}>Заборави лозинка?</a>
                            </div>
                        </Form.Item>
                    </Form>
                </Card>
            </div>
        </div>
    )
}

const Register = ({setUser}) => {

    const [loading, setLoading] = useState(false)
    const history = useNavigate()
    const register = (attr) => {
        if (attr.password !== attr.confirm) {
            Modal.error({
                title: 'Лозинките не се исти',
            });
            return;
        }
        setLoading(true)
        axios.post(env.api+'Users/register',{email: attr.email, password: attr.password,isConfirmed:false}).then(res => {
            setAuthCookie(res.data.token)
            setUser(res.data)
            setLoading(false)
            history('/confirm-email')
        })
    }

    const googleLoginResponse = (response)=>{
        console.log(response)
        setLoading(true)
        console.log(response.tokenId)
        setAuthCookie('Bearer '+response.tokenId)
        axios.post(env.api+'Users/register',{email: response.profileObj.email, password:'', isConfirmed: true}).then(res => {
            setUser(res.data)
            setLoading(false)
            history('/')
        })
    }

    const facebookLoginResponse = (response) =>{
        console.log(response)
        setLoading(true)
        setAuthCookie('Bearer '+response.accessToken)
        axios.post(env.api+'Users/register',{email: response.email, password:'', isConfirmed: true}).then(res => {
            setUser(res.data)
            setLoading(false)
            history('/')
        })
    }


    return(
        <div style={{width:'100vw',height:'100vh', textAlign:'center', backgroundColor:'#F2F2F2'}}>
            <div className='center'>
                <Card style={{backgroundColor:'white', width:'100%', borderRadius:'20px'}} className='center'>
                    <h1>Регистрирај се</h1>
                    <Form
                        name="normal_login"
                        onFinish={(attr)=>register(attr)}
                    >
                        <Form.Item
                            name="email"
                            rules={[
                                {
                                    required: true,
                                    message: 'Внесете мејл',
                                },
                                {
                                    type: 'email',
                                    message: 'Внесете валиден мејл',
                                },
                            ]}
                        >
                            <Input prefix={<UserOutlined className="site-form-item-icon" />} placeholder="Email" />
                        </Form.Item>
                        <Form.Item
                            name="password"
                            rules={[
                                {
                                    required: true,
                                    message: 'Внесете лозинка!',
                                },
                            ]}
                        >
                            <Input
                                prefix={<LockOutlined className="site-form-item-icon" />}
                                type="password"
                                placeholder="Password"
                            />
                        </Form.Item>
                        <Form.Item
                            name="confirm"
                            rules={[
                                {
                                    required: true,
                                    message: 'Потврдете лозинка!',
                                },
                            ]}
                        >
                            <Input
                                prefix={<LockOutlined className="site-form-item-icon" />}
                                type="password"
                                placeholder="Confirm password"
                            />
                        </Form.Item>

                        <Form.Item style={{margin:'0px'}}>
                            <Button type="primary" htmlType="submit" className="login-form-button" loading={loading} style={{marginBottom:'5px'}}>
                                Register
                            </Button>
                            <br/>
                            <GoogleLogin
                                clientId="748923557453-ljii8ulhti93man769d2dd9soi7038j5.apps.googleusercontent.com"
                                buttonText="Регистрирај се со Google"
                                onSuccess={googleLoginResponse}
                            />
                            <div style={{margin:'5px'}}/>
                            <FacebookLogin
                                appId="1455131645009417"
                                size={'small'}
                                textButton={'Регистрирај се со FB'}
                                icon="fa-facebook"
                                fields="name,email"
                                callback={facebookLoginResponse} />
                            <div>
                                Или <a href={"/login"}>најави се!</a>
                            </div>
                        </Form.Item>
                    </Form>
                </Card>
            </div>
        </div>
    )
}

export {Login,Register};