import React from 'react'
import {Menu} from "antd";
import {Link, useNavigate} from "react-router-dom";
import {Outlet} from "react-router";
import {
    BookOutlined,
    BulbOutlined,
    ContainerOutlined,
    QuestionCircleOutlined, StarOutlined,
    UserOutlined
} from "@ant-design/icons";
import * as PropTypes from "prop-types";
import {Header} from "./Header";

Header.propTypes = {onClick: PropTypes.func};
const Dashboard = ({setUser}) => {
    const history = useNavigate()
    const logout = () => {
        localStorage.removeItem('Auth');
        setUser(false)
    }
    return(
        <div>
            <Header onClickButton={() => logout()} buttonText={'Одјави се'}/>
            <div style={{width: '20%', display: 'inline-block', verticalAlign: 'top'}}>
                <Menu
                    style={{width: '100%'}}
                    defaultSelectedKeys={['1']}
                    mode="inline"
                >
                    <Menu.Item key="1" icon={<BulbOutlined/>}><Link to="/dashboard">Ресторан</Link></Menu.Item>
                    <Menu.Item key="2" icon={<ContainerOutlined/>}><Link to="/dashboard/menu">Мени</Link></Menu.Item>
                    <Menu.Item key="3" icon={<UserOutlined/>}><Link
                        to="/dashboard/reservations">Резервации</Link></Menu.Item>
                    <Menu.Item key="4" icon={<QuestionCircleOutlined/>}><Link
                        to="/dashboard/reviews">Оценки</Link></Menu.Item>
                    <Menu.Item key="5" icon={<BookOutlined/>}><Link to="/dashboard/todo">ToDo</Link></Menu.Item>
                    <Menu.Item key="6" icon={<StarOutlined />}><Link to="/dashboard/vip">VIP</Link></Menu.Item>
                </Menu>
            </div>
            <div style={{
                width: '80%',
                display: 'inline-block',
                backgroundColor: '#F2F2F2',
                verticalAlign: 'top',
                textAlign: 'center',
                height: '92vh',
                overflow: 'auto'
            }}>
                <Outlet/>
            </div>
        </div>
    )
}

export default Dashboard