﻿using backend.Data;
using Microsoft.EntityFrameworkCore;
using Quartz;
using SendGrid;
using SendGrid.Helpers.Mail;

namespace backend.Jobs
{
    public class QueueJob : IJob
    {
        private readonly DataContext _context = null;
        public QueueJob(DataContext context)
        {
            _context = context;
        }
        public async Task Execute(IJobExecutionContext context)
        {
            var items = await _context.QueueItems.OrderBy(x => x.CreatedAt).Take(10).ToListAsync();
            var client = new SendGridClient("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");
            foreach(var item in items)
            {
                var msg = new SendGridMessage()
                {
                    From = new EmailAddress("danilo.najkov@students.finki.ukim.mk",
                                            "Danilo"),
                    Subject = item.Subject,
                    HtmlContent = item.Message
                };
                msg.AddTo(new EmailAddress(item.Reciptient));
                msg.SetClickTracking(false, false);

                var response = await client.SendEmailAsync(msg);
                if (response.IsSuccessStatusCode)
                {
                    _context.QueueItems.Remove(item);
                }
                else if (item.Retries == 2)
                {
                    _context.QueueItems.Add(new Entities.QueueItem()
                    { 
                        CreatedAt=DateTime.UtcNow, 
                        Subject="Неуспешно испратена порака",
                        Message="Порака: "+item.Subject+", до "+item.Reciptient+" беше неуспешно пратена.",
                        Retries=0
                    });
                    _context.QueueItems.Remove(item);
                }
                else
                {
                    item.Retries++;
                    _context.QueueItems.Update(item);
                }
            }
            await _context.SaveChangesAsync();
        }
    }
}
