﻿using backend.Data;
using backend.DTOs;
using backend.Entities;
using Microsoft.EntityFrameworkCore;

namespace backend.Services
{
    public interface IMenuService
    {
        public Task AddMenu(CreateMenuItemRequest menu);
        public Task RemoveMenu(int id);
        public Task UploadImage(int id, IFormFile file);
    }
    public class MenuService : IMenuService
    {
        private readonly DataContext _context = null;
        public MenuService(DataContext context)
        {
            _context = context;
        }
        public async Task AddMenu(CreateMenuItemRequest menu)
        {
            var res = await _context.Restoraunts.FirstOrDefaultAsync();
            if(res.Menu == null)
            {
                res.Menu = new List<MenuItem>();
            }
            res.Menu.Add(new MenuItem()
            {
                Title = menu.Title,
                Description = menu.Description,
                Price = menu.Price,
                Alergens = menu.Alergens,
                IsVipOnly = menu.IsVipOnly,
                Image = Array.Empty<byte>()
            }) ;
            _context.Restoraunts.Update(res);
            await _context.SaveChangesAsync();
        }

        public async Task RemoveMenu(int id)
        {
            var res = await _context.Restoraunts.Include(x => x.Menu).FirstOrDefaultAsync();
            res.Menu = res.Menu.Where(x => x.Id != id).ToList();
            _context.Restoraunts.Update(res);
            await _context.SaveChangesAsync();
        }

        public async Task UploadImage(int id, IFormFile file)
        {
            using (var memoryStream = new MemoryStream())
            {
                await file.CopyToAsync(memoryStream);
                var menuItem = await _context.MenuItems.FindAsync(id);
                menuItem.Image = memoryStream.ToArray();
                _context.MenuItems.Update(menuItem);
                _context.SaveChanges();
            }
        }
    }
}
