package com.example.skychasemk.controller;

import com.example.skychasemk.dto.WishlistDTO;
import com.example.skychasemk.model.Flight;
import com.example.skychasemk.model.Wishlist;
import com.example.skychasemk.repository.BookingRepository;
import com.example.skychasemk.repository.FlightRepository;
import com.example.skychasemk.repository.WishlistRepository;
import com.example.skychasemk.services.WishlistService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping("/api/wishlists")
public class WishlistController {

    @Autowired
    private WishlistService wishlistService;

    @Autowired
    private WishlistRepository wishlistRepository;

    @Autowired
    private FlightRepository flightRepository;

    @GetMapping
    public List<Wishlist> getAllWishlists() {
        return wishlistRepository.findAll();
    }

    @PostMapping("/add")
    public Wishlist createWishlist(@RequestBody Wishlist wishlist) {
        return wishlistService.saveWishlist(wishlist);
    }

    @DeleteMapping
    public void deleteWishlist(@RequestParam("userId") Integer userId, @RequestParam("targetId") Integer targetId) {
        wishlistService.deleteRecordFromWishlist(userId, targetId);
    }

    @GetMapping("/{userId}")
    public ResponseEntity<List<Wishlist>> getWishlist(@PathVariable Long userId) {
        List<Wishlist> wishlist = wishlistService.getAllItems(userId);
        return ResponseEntity.ok(wishlist);
    }

    @GetMapping("/flight/{wishlistId}")
    public ResponseEntity<List<Optional<Wishlist>>> getFlight(@PathVariable Long wishlistId){
        Optional<Wishlist> wishlist = wishlistRepository.getFlightFromWishlist(wishlistId);
        return ResponseEntity.ok(Collections.singletonList(wishlist));
    }

    @PostMapping
    public ResponseEntity<String> updateWishlist(@RequestBody WishlistDTO wishlistRequest) {
        try {
            wishlistService.updateWishlist(wishlistRequest);
            return ResponseEntity.ok("Wishlist updated successfully");
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body("Error updating wishlist");
        }
    }

}
