package com.example.skychasemk.repository;

import com.example.skychasemk.model.Flight;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.time.LocalDate;
import java.util.List;

@Repository
public interface FlightRepository extends JpaRepository<Flight, Long> {

    @Query(value = "SELECT * FROM flight WHERE departure_airport = :departureID AND arrival_airport = :destinationID AND departure_date = :departureDate", nativeQuery = true)
    List<Flight> findFlights(@Param("departureID") Integer departureID,
                             @Param("destinationID") Integer destinationID,
                             @Param("departureDate") LocalDate departureDate);


    @Query(value="SELECT * FROM flight  WHERE flightId=:flightId",nativeQuery = true)
    List<Flight> getFlightByFlightId(Long flightId);
}
