package com.example.skychasemk.repository;

import com.example.skychasemk.dto.WishlistDTO;
import com.example.skychasemk.model.Flight;
import com.example.skychasemk.model.Wishlist;
import jakarta.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

@Repository
public interface WishlistRepository extends JpaRepository<Wishlist, Integer> {

    @Query("SELECT w FROM Wishlist w WHERE w.targetId = :targetId AND w.userId = :userId")
    Wishlist findByTargetIdAndUserId(Integer targetId, Integer userId);

    @Query("SELECT w FROM Wishlist w WHERE w.userId = :userId")
    List<Wishlist> findWishlistByUserId(@Param("userId") Long userId);

    @Modifying
    @Transactional
    @Query("DELETE FROM Wishlist w WHERE w.userId = :userId AND w.targetId = :targetId")
    void deleteByUserIdAndTargetId(@Param("userId") Integer userId, @Param("targetId") Integer targetId);

    @Query("SELECT w.targetId FROM Wishlist w WHERE w.wishlistID = :wishlistId")
    Optional<Wishlist> getFlightFromWishlist(@Param("wishlistId") Long wishlistId);
}
