package com.example.skychasemk.repository;

import com.example.skychasemk.model.Notification;
import com.example.skychasemk.model.Review;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;

public interface ReviewRepository extends JpaRepository<Review, Integer> {
    @Query("SELECT r from Review r where r.targetID = :flightId")
    List<Review> findReviews(@Param("flightId") Integer flightId);

    @Query("SELECT r FROM Review r WHERE r.userID = :userId")
    List<Review> findByUserId(@Param("userId") Integer userId);
}

