package com.example.skychasemk.model;

import jakarta.persistence.*;
import java.time.LocalDate;

@Entity
@Table(name="notification")
public class Notification {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "notificationid")

    private Integer notificationID;
    @Column(name = "userid")

    private Integer userID;
    @Column(name = "message")

    private String message;
    @Column(name = "type")

    @Enumerated(EnumType.STRING)
    private Type type;
    @Column(name = "date_sent")

    private LocalDate dateSent;

    public enum Type {
        BOOKING_CONFIRMATION,
        FLIGHT_DELAY,
        GENERAL_UPDATE
    }

    // Getters and Setters
    public Integer getNotificationID() {
        return notificationID;
    }

    public void setNotificationID(Integer notificationID) {
        this.notificationID = notificationID;
    }

    public Integer getUserID() {
        return userID;
    }

    public void setUserID(Integer userID) {
        this.userID = userID;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Type getType() {
        return type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public LocalDate getDateSent() {
        return dateSent;
    }

    public void setDateSent(LocalDate dateSent) {
        this.dateSent = dateSent;
    }
}
