package com.example.skychasemk.model;

import jakarta.persistence.*;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDate;

@Getter
@Entity
@Table(name="Payment")
public class Payment {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "PaymentID")

    private Integer paymentID;

    @Column(name = "bookingid")

    private Integer bookingID;
    @Column(name = "UserID")

    private Integer userID;
    @Setter
    @Column(name = "payment_method")

    @Enumerated(EnumType.STRING)
    private PaymentMethod method;
    @Setter
    @Column(name = "Amount")

    private BigDecimal amount;
    @Setter
    @Getter
    @Column(name = "transaction_date")

    private LocalDate transactionDate;
    @Column(name = "payment_status")

    @Enumerated(EnumType.STRING)
    private PaymentStatus status;

    public enum PaymentStatus {
        PENDING,
        COMPLETED,
        CANCELLED
    }

    public enum PaymentMethod {
        PAYPAL,
        DEBIT,
        CREDIT
    }

    public Integer getPaymentID() {
        return paymentID;
    }

    public Integer getBookingID() {
        return bookingID;
    }

    public Integer getUserID() {
        return userID;
    }

    public void setUserID(Integer userID) {
        this.userID = userID;
    }

    public PaymentMethod getMethod() {
        return method;
    }

    public void setMethod(PaymentMethod method) {
        this.method = method;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setPaymentID(Integer paymentID) {
        this.paymentID = paymentID;
    }

    public void setBookingID(Integer bookingID) {
        this.bookingID = bookingID;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public LocalDate getTransactionDate() {
        return transactionDate;
    }

    public void setTransactionDate(LocalDate transactionDate) {
        this.transactionDate = transactionDate;
    }

    public PaymentStatus getStatus() {
        return status;
    }

    public void setStatus(PaymentStatus status) {
        this.status = status;
    }

    public void setUserID(Long userID) {
        this.userID = Math.toIntExact(userID);
    }

}

