package com.example.skychasemk.controller;

import com.example.skychasemk.dto.BookingDTO;
import com.example.skychasemk.model.Booking;
import com.example.skychasemk.repository.BookingRepository;
import com.example.skychasemk.services.BookingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDate;
import java.util.Optional;

@RestController
@RequestMapping("/api")
public class BookingController {

    @Autowired
    private BookingService bookingService;

    @Autowired
    private BookingRepository bookingRepository;


    @GetMapping("/flights/id/{id}")
    public Optional<Booking> getBookingById(@PathVariable("id") Integer bookingID) {
        return bookingService.getBookingById(bookingID);
    }

    @PutMapping("/flights/{id}")
    public Booking updateBooking(@PathVariable("id") Integer bookingID, @RequestBody Booking booking) {
        return bookingService.updateBooking(bookingID, booking);
    }

    @GetMapping("/bookings/getAll/{flightId}")
    public Booking getAllBookings(@PathVariable Integer flightId){
        return (Booking) bookingRepository.findBookingsByFlightId(flightId);
    }

    @PostMapping("/bookings")
    public Booking createBooking(@RequestBody BookingDTO bookingRequest) {
        Booking newBooking = new Booking();
        newBooking.setUserID(bookingRequest.getUserID());
        newBooking.setFlightId(bookingRequest.getFlightId());
        newBooking.setBookingDate(LocalDate.now());
        newBooking.setStatus(Booking.payment_status.PENDING);
        newBooking.setTotalCost(bookingRequest.getTotalCost());
        newBooking.setSeatNumber(bookingRequest.getSeatNumber());
        System.out.println("Saving Booking: " + newBooking);

        return bookingRepository.save(newBooking);
    }
}

