package com.example.skychasemk.controller;

import com.example.skychasemk.model.Destination;
import com.example.skychasemk.services.DestinationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping("/api/destinations")
public class DestinationController {

    @Autowired
    private DestinationService destinationService;

    // Get all destinations
    @GetMapping
    public List<Destination> getAllDestinations() {
        return destinationService.getAllDestinations();
    }

    // Get destination by ID
    @GetMapping("/{id}")
    public Optional<Destination> getDestinationById(@PathVariable("id") Integer destinationID) {
        return destinationService.getDestinationById(destinationID);
    }


    // Update an existing destination
    @PutMapping("/{id}")
    public Destination updateDestination(@PathVariable("id") Integer destinationID, @RequestBody Destination destination) {
        return destinationService.updateDestination(destinationID, destination);
    }

    // Delete a destination
    @DeleteMapping("/{id}")
    public void deleteDestination(@PathVariable("id") Integer destinationID) {
        destinationService.deleteDestination(destinationID);
    }
    @GetMapping("/destinations")
    public List<String> getDestinations() {
        return destinationService.getAllCities();
    }
}
