package com.example.skychasemk.controller;

import com.example.skychasemk.model.Notification;
import com.example.skychasemk.services.NotificationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping("/api/notifications")
public class NotificationController {

    @Autowired
    private NotificationService notificationService;

    // Get all notifications
    @GetMapping
    public List<Notification> getAllNotifications() {
        return notificationService.getAllNotifications();
    }

    // Get notification by ID
    @GetMapping("/{id}")
    public Optional<Notification> getNotificationById(@PathVariable("id") Integer notificationID) {
        return notificationService.getNotificationById(notificationID);
    }

    // Create a new notification
    @PostMapping
    public Notification createNotification(@RequestBody Notification notification) {
        return notificationService.saveNotification(notification);
    }

    // Update an existing notification
    @PutMapping("/{id}")
    public Notification updateNotification(@PathVariable("id") Integer notificationID, @RequestBody Notification notification) {
        return notificationService.updateNotification(notificationID, notification);
    }

    // Delete a notification
    @DeleteMapping("/{id}")
    public void deleteNotification(@PathVariable("id") Integer notificationID) {
        notificationService.deleteNotification(notificationID);
    }
}
