package com.example.skychasemk.controller;

import com.example.skychasemk.dto.PaymentDTO;
import com.example.skychasemk.model.Payment;
import com.example.skychasemk.services.PaymentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping("/api")
public class PaymentController {

    @Autowired
    private PaymentService paymentService;

    // Get payment by ID
    @GetMapping("/payments/{id}")
    public Optional<Payment> getPaymentById(@PathVariable("id") Integer paymentID) {
        return paymentService.getPaymentById(paymentID);
    }

    @PostMapping("/payments")
    public ResponseEntity<Payment> createPayment(@RequestBody PaymentDTO dto) {
        Payment payment = paymentService.createTransaction(dto);
        return ResponseEntity.ok(payment);
    }

    // Update an existing payment
    @PutMapping("/payments/{id}")
    public Payment updatePayment(@PathVariable("id") Integer paymentID, @RequestBody Payment payment) {
        return paymentService.updatePayment(paymentID, payment);
    }

    // Delete a payment
    @DeleteMapping("/payments/{id}")
    public void deletePayment(@PathVariable("id") Integer paymentID) {
        paymentService.deletePayment(paymentID);
    }
}

