package com.example.skychasemk.controller;

import com.example.skychasemk.dto.ReviewDTO;
import com.example.skychasemk.model.Review;
import com.example.skychasemk.services.ReviewService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping("/api/reviews")
public class ReviewController {

    @Autowired
    private ReviewService reviewService;

    // Get all reviews
    @GetMapping
    public List<Review> getAllReviews() {
        return reviewService.getAllReviews();
    }

    // Get review by ID
    @GetMapping("/{id}")
    public Optional<Review> getReviewById(@PathVariable("id") Integer reviewID) {
        return reviewService.getReviewById(reviewID);
    }

    @PostMapping
    public ResponseEntity<Review> submitReview(@RequestBody ReviewDTO dto) {
        Review savedReview = reviewService.submitReview(dto);
        return ResponseEntity.ok(savedReview);
    }

    // Update an existing review
    @PutMapping("/{id}")
    public Review updateReview(@PathVariable("id") Integer reviewID, @RequestBody Review review) {
        return reviewService.updateReview(reviewID, review);
    }

    // Delete a review
    @DeleteMapping("/{id}")
    public void deleteReview(@PathVariable("id") Integer reviewID) {
        reviewService.deleteReview(reviewID);
    }
}
