package com.example.skychasemk.controller;

import com.example.skychasemk.dto.WishlistDTO;
import com.example.skychasemk.model.Wishlist;
import com.example.skychasemk.services.WishlistService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/wishlists")
public class WishlistController {

    @Autowired
    private WishlistService wishlistService;

    @GetMapping("/wishlists-all")
    public List<Wishlist> getAllWishlists() {
        return wishlistService.getAllWishlists();
    }
    @PostMapping("/add")
    public Wishlist createWishlist(@RequestBody Wishlist wishlist) {
        return wishlistService.saveWishlist(wishlist);
    }

    @DeleteMapping("/wishlist/{id}")
    public void deleteWishlist(@PathVariable("id") Integer wishlistID) {
        wishlistService.deleteWishlist(wishlistID);
    }

    @PostMapping
    public ResponseEntity<String> updateWishlist(@RequestBody WishlistDTO wishlistRequest) {
        try {
            wishlistService.updateWishlist(wishlistRequest);
            return ResponseEntity.ok("Wishlist updated successfully");
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).body("Error updating wishlist");
        }
    }

}
