package com.example.skychasemk.dto;

import lombok.Getter;

import java.math.BigDecimal;
import java.time.LocalDate;

public class PaymentDTO {

    // Getters and Setters
    @Getter
    private Long paymentID;
    @Getter
    private Integer bookingID;
    private Integer userID;
    @Getter
    private PaymentMethod method;
    @Getter
    private BigDecimal amount;
    @Getter
    private LocalDate transactionDate;
    @Getter
    private PaymentStatus status;
    @Getter
    private Long flightId;

    public void setFlightId(Long flightId) {
        this.flightId = flightId;
    }

    public enum PaymentStatus {
        PENDING,
        COMPLETED,
        CANCELLED
    }

    public enum PaymentMethod {
        PAYPAL,
        DEBIT,
        CREDIT
    }

    public void setPaymentID(Long paymentID) {
        this.paymentID = paymentID;
    }

    public void setBookingID(Integer bookingID) {
        this.bookingID = bookingID;
    }

    public Long getUserID() {
        return Long.valueOf(userID);
    }

    public void setUserID(Integer userID) {
        this.userID = userID;
    }

    public void setMethod(PaymentMethod method) {
        this.method = method;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setTransactionDate(LocalDate transactionDate) {
        this.transactionDate = transactionDate;
    }

    public void setStatus(PaymentStatus status) {
        this.status = status;
    }
}

