package com.example.skychasemk.model;

import jakarta.persistence.*;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDate;

@Entity
@Table(name="Booking")
public class Booking {

    @Setter
    @Getter
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "BookingID")

    private Integer bookingID;
    @Setter
    @Getter
    @Column(name = "UserID")

    private Integer userID;

    //@Column(name = "flightid")

    //private Integer flightId;
    @Column(name = "booking_date")

    private LocalDate booking_date;
    @Setter
    @Getter
    @Column(name = "payment_status")

    @Enumerated(EnumType.STRING)
    private payment_status status;
    @Column(name = "total_cost")

    private BigDecimal total_cost;
    @Column(name = "seat_number")

    private Integer seat_number;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "flightid")
    Flight flightId;

    public Flight getFlightId() {
        return flightId;
    }

    public void setFlightId(Flight flightId) {
        this.flightId = flightId;
    }

    public enum payment_status {
        PENDING,
        COMPLETED,
        CANCELLED
    }

    public LocalDate getBookingDate() {
        return booking_date;
    }

    public Integer getBookingID() {
        return bookingID;
    }

    public void setBookingID(Integer bookingID) {
        this.bookingID = bookingID;
    }

    public Integer getUserID() {
        return userID;
    }

    public void setUserID(Integer userID) {
        this.userID = userID;
    }

    public LocalDate getBooking_date() {
        return booking_date;
    }

    public void setBooking_date(LocalDate booking_date) {
        this.booking_date = booking_date;
    }

    public payment_status getStatus() {
        return status;
    }

    public void setStatus(payment_status status) {
        this.status = status;
    }

    public BigDecimal getTotal_cost() {
        return total_cost;
    }

    public void setTotal_cost(BigDecimal total_cost) {
        this.total_cost = total_cost;
    }

    public Integer getSeat_number() {
        return seat_number;
    }

    public void setSeat_number(Integer seat_number) {
        this.seat_number = seat_number;
    }

    public void setBookingDate(LocalDate bookingDate) {
        this.booking_date = bookingDate;
    }

    public BigDecimal getTotalCost() {
        return total_cost;
    }

    public void setTotalCost(BigDecimal totalCost) {
        this.total_cost = totalCost;
    }

    public Integer getSeatNumber() {
        return seat_number;
    }

    public void setSeatNumber(Integer seat_number) {
        this.seat_number = seat_number;
    }
}
