package com.example.skychasemk.model;

import jakarta.persistence.*;

import java.util.List;

@Entity
@Table(name="Destination")
public class Destination {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "DestinationID")

    private Integer destinationID;
    @Column(name = "Name")

    private String name;
    @Column(name = "Country")

    private String country;
    @Column(name = "Description")

    private String description;
    @Column(name = "popular_attraction")

    private String popularAttraction;
    @Column(name = "best_time_to_visit")

    private String bestTimeToVisit;

    public Integer getDestinationID() {
        return destinationID;
    }

    public void setDestinationID(Integer destinationID) {
        this.destinationID = destinationID;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPopularAttraction() {
        return popularAttraction;
    }

    public void setPopularAttraction(String popularAttraction) {
        this.popularAttraction = popularAttraction;
    }

    public String getBestTimeToVisit() {
        return bestTimeToVisit;
    }

    public void setBestTimeToVisit(String bestTimeToVisit) {
        this.bestTimeToVisit = bestTimeToVisit;
    }

    public static Integer getAirportID(String cityName, List<Destination> destinations) {
        for (Destination destination : destinations) {
            if (destination.getName().equalsIgnoreCase(cityName)) {
                return destination.getDestinationID();
            }
        }
        return null;
    }
}
