package com.example.skychasemk.model;

import jakarta.persistence.*;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;

@Setter
@Getter
@Entity
@Table(name="Flight")
public class Flight {

    // Getters and Setters
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "FlightID")
    private Long flightID;
    @Column(name = "flight_number")

    private String flightNumber;
    @Column(name = "departure_airport")

    private Integer departureAirport;
    @Column(name = "arrival_airport")

    private Integer arrivalAirport;
    @Column(name = "departure_time")

    private LocalTime departureTime;
    @Column(name = "arrival_time")

    private LocalTime arrivalTime;
    @Column(name = "Price")

    private BigDecimal price;
    @Column(name = "available_seats")

    private Integer availableSeats;
    @Column(name = "departureDate")

    private LocalDate departureDate;

    @Column(name="returnDate")
    private LocalDate returnDate;

    @OneToMany(mappedBy = "flightId", fetch = FetchType.LAZY)
    private List<Booking> bookings;

}

