package com.example.skychasemk.model;

import jakarta.persistence.*;
import lombok.Getter;

import java.time.LocalDate;

@Entity
@Table(name="supportticket")
public class SupportTicket {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "TicketID")

    private Integer ticketID;
    @Getter
    @Column(name = "UserID")

    private Integer userID;
    @Column(name = "Subject")

    private String subject;
    @Getter
    @Column(name = "Description")

    private String description;
    @Getter
    @Column(name = "status")
    @Enumerated(EnumType.STRING)
    private TicketStatus status;
    @Column(name = "date_created")

    private LocalDate dateCreated;
    @Getter
    @Column(name = "date_resolved")

    private LocalDate dateResolved;
    @Column(name = "assigned_to")

    private Integer assignedTo;

    public enum TicketStatus {
        OPEN,
        RESOLVED;
    }

    public TicketStatus getStatus() {
        return status;
    }

    public Integer getTicketID() {
        return ticketID;
    }

    public void setTicketID(Integer ticketID) {
        this.ticketID = ticketID;
    }

    public void setUserID(Integer userID) {
        this.userID = userID;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStatus(TicketStatus status) {
        this.status = status;
    }

    public LocalDate getDateCreated(LocalDate now) {
        return dateCreated;
    }

    public void setDateCreated(LocalDate dateCreated) {
        this.dateCreated = dateCreated;
    }

    public void setDateResolved(LocalDate dateResolved) {
        this.dateResolved = dateResolved;
    }

    public void setAssignedTo(Integer assignedTo) {
        this.assignedTo = assignedTo;
    }
}