package com.example.skychasemk.model;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebConfig implements WebMvcConfigurer {

    @Override
    public void addCorsMappings(CorsRegistry registry) {
        // Allow cross-origin requests from your frontend
        registry.addMapping("/**")
                .allowedOrigins("http://localhost:8080")
                .allowedMethods("GET", "POST", "PUT", "DELETE")
                .allowedHeaders("*")
                .allowCredentials(true);
    }
    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("/**")
                .addResourceLocations("classpath:/static/");
    }
    @Override
    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/admin").setViewName("forward:/AdminLogin.html");
        registry.addViewController("/flights").setViewName("forward:/FlightSearch.html");
        registry.addViewController("/my-reservations").setViewName("forward:/MyReservations.html");
        registry.addViewController("/reviews").setViewName("forward:/ReviewPage.html");
        registry.addViewController("/support-tickets").setViewName("forward:/SupportTickets.html");
        registry.addViewController("/transaction").setViewName("forward:/TransactionPage.html");
        registry.addViewController("/login").setViewName("forward:/UserLogin.html");
        registry.addViewController("/wishlist").setViewName("forward:/WishlistPage.html");
        registry.addViewController("/signup").setViewName("forward:/UserSignup.html");
    }

}
