package com.example.skychasemk.repository;

import com.example.skychasemk.model.ApplicationUser;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Optional;

@Repository
public interface ApplicationUserRepository extends JpaRepository<ApplicationUser, Long> {
    Optional<ApplicationUser> findByEmail(String email);
    @Query("SELECT u FROM ApplicationUser u WHERE u.userid = :id")
    Optional<ApplicationUser> getUserById(@Param("id") Long userid);
}