package com.example.skychasemk.repository;

import com.example.skychasemk.dto.WishlistDTO;
import com.example.skychasemk.model.Flight;
import com.example.skychasemk.model.Wishlist;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public interface WishlistRepository extends JpaRepository<Wishlist, Integer> {

    @Query("SELECT w FROM Wishlist w WHERE w.targetID = :targetId AND w.userID = :userId")
    Wishlist findByTargetIdAndUserId(Integer targetId, Integer userId);
}
