package com.example.skychasemk.services;

import com.example.skychasemk.model.Airport;
import com.example.skychasemk.repository.AirportRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
public class AirportService {

    @Autowired
    private AirportRepository airportRepository;

    // Get all airports
    public List<Airport> getAllAirports() {
        return airportRepository.findAll();
    }

    // Get airport by ID
    public Optional<Airport> getAirportById(Integer airportID) {
        return airportRepository.findById(airportID);
    }

    // Save new airport
    public Airport saveAirport(Airport airport) {
        return airportRepository.save(airport);
    }

    // Update an airport
    public Airport updateAirport(Integer airportID, Airport airport) {
        if (airportRepository.existsById(airportID)) {
            airport.setAirportID(airportID);
            return airportRepository.save(airport);
        } else {
            throw new RuntimeException("Airport not found with id " + airportID);
        }
    }

    // Delete airport
    public void deleteAirport(Integer airportID) {
        airportRepository.deleteById(airportID);
    }
}
