package com.example.skychasemk.services;

import com.example.skychasemk.model.Destination;
import com.example.skychasemk.repository.DestinationRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
public class DestinationService {

    @Autowired
    private DestinationRepository destinationRepository;

    // Get all destinations
    public List<Destination> getAllDestinations() {
        return destinationRepository.findAll();
    }

    // Get destination by ID
    public Optional<Destination> getDestinationById(Integer destinationID) {
        return destinationRepository.findById(destinationID);
    }

    // Save a new destination
    public Destination saveDestination(Destination destination) {
        return destinationRepository.save(destination);
    }

    // Update an existing destination
    public Destination updateDestination(Integer destinationID, Destination destination) {
        if (destinationRepository.existsById(destinationID)) {
            destination.setDestinationID(destinationID);
            return destinationRepository.save(destination);
        } else {
            throw new RuntimeException("Destination not found with id " + destinationID);
        }
    }

    // Delete destination
    public void deleteDestination(Integer destinationID) {
        destinationRepository.deleteById(destinationID);
    }

    public List<String> getAllCities() {
        return destinationRepository.findAllCities();
    }
}
