package com.example.skychasemk.services;

import com.example.skychasemk.model.Notification;
import com.example.skychasemk.repository.NotificationRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
public class NotificationService {

    @Autowired
    private NotificationRepository notificationRepository;

    // Get all notifications
    public List<Notification> getAllNotifications() {
        return notificationRepository.findAll();
    }

    // Get notification by ID
    public Optional<Notification> getNotificationById(Integer notificationID) {
        return notificationRepository.findById(notificationID);
    }

    // Save a new notification
    public Notification saveNotification(Notification notification) {
        return notificationRepository.save(notification);
    }

    // Update an existing notification
    public Notification updateNotification(Integer notificationID, Notification notification) {
        if (notificationRepository.existsById(notificationID)) {
            notification.setNotificationID(notificationID);
            return notificationRepository.save(notification);
        } else {
            throw new RuntimeException("Notification not found with id " + notificationID);
        }
    }

    // Delete notification
    public void deleteNotification(Integer notificationID) {
        notificationRepository.deleteById(notificationID);
    }
}

