package com.example.skychasemk.model;

import jakarta.persistence.*;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDate;

@Entity
@Table(name="supportticket")
public class SupportTicket {

    @Setter
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "TicketID")

    private Integer ticketID;
    @Setter
    @Getter
    @Column(name = "userid")

    private Integer userId;

    @Setter
    @Getter
    @Column(name = "Description")

    private String description;
    @Setter

    @Getter
    @Column(name = "status")
    @Enumerated(EnumType.STRING)
    private TicketStatus status;
    @Setter
    @Column(name = "date_created")

    private LocalDate dateCreated;
    @Setter
    @Getter
    @Column(name = "date_resolved")

    private LocalDate dateResolved;
    @Setter
    @Column(name = "assigned_to")

    private Integer assignedTo;

    public enum TicketStatus {
        OPEN,
        RESOLVED;
    }


    public LocalDate getDateCreated(LocalDate now) {
        return dateCreated;
    }

}