package com.example.skychasemk.model;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;

public class TopMonthlyReportId implements Serializable {
    private LocalDate month;
    private String category;
    private String name;

    public TopMonthlyReportId() {}

    public TopMonthlyReportId(LocalDate month, String category, String name) {
        this.month = month;
        this.category = category;
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TopMonthlyReportId that = (TopMonthlyReportId) o;
        return Objects.equals(month, that.month) &&
                Objects.equals(category, that.category) &&
                Objects.equals(name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(month, category, name);
    }
}
