package com.example.skychasemk.services;

import com.example.skychasemk.dto.WishlistDTO;
import com.example.skychasemk.model.Booking;
import com.example.skychasemk.model.Flight;
import com.example.skychasemk.model.Wishlist;
import com.example.skychasemk.repository.FlightRepository;
import com.example.skychasemk.repository.WishlistRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.time.LocalDate;
import java.util.List;
import java.util.Optional;

@Service
public class WishlistService {

    @Autowired
    private WishlistRepository wishlistRepository;

    @Autowired
    private FlightRepository flightRepository;

    public List<Wishlist> getAllWishlists() {
        return wishlistRepository.findAll();
    }


    public Wishlist saveWishlist(Wishlist wishlist) {
        if (wishlist == null) {
            throw new IllegalArgumentException("Wishlist cannot be null");
        }
        wishlist.setDate_added(LocalDate.now());
        return wishlistRepository.save(wishlist);
    }


    public void updateWishlist(WishlistDTO wishlistRequest) {
        Flight flight = flightRepository.findById(Long.valueOf(wishlistRequest.getTargetID()))
                .orElseThrow(() -> new IllegalArgumentException("Flight not found"));

        if (wishlistRequest.isWishlisted()) {
            Wishlist existingItem = wishlistRepository.findByTargetIdAndUserId(wishlistRequest.getTargetID(), wishlistRequest.getUserID());

            if (existingItem == null) {
                Wishlist newWishlistItem = new Wishlist();
                newWishlistItem.setTargetId(Math.toIntExact(wishlistRequest.getTargetID()));
                newWishlistItem.setUserId(wishlistRequest.getUserID());
                newWishlistItem.setDate_added(LocalDate.now());
                wishlistRepository.save(newWishlistItem);
            }
        } else {
            Wishlist existingItem = wishlistRepository.findByTargetIdAndUserId(wishlistRequest.getTargetID(), wishlistRequest.getUserID());

            if (existingItem != null) {
                wishlistRepository.delete(existingItem);
            }
        }
    }

    public List<Wishlist> getAllItems(Long userId) {
        return wishlistRepository.findWishlistByUserId(userId);
    }

    public void deleteRecordFromWishlist(Integer userId, Integer targetId) {
        wishlistRepository.deleteByUserIdAndTargetId(userId, targetId);
    }
}

