package com.example.skychasemk.controller;

import com.example.skychasemk.dto.ReviewDTO;
import com.example.skychasemk.model.Review;
import com.example.skychasemk.repository.ReviewRepository;
import com.example.skychasemk.services.ReviewService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/reviews")
public class ReviewController {

    @Autowired
    private ReviewService reviewService;
    @Autowired
    private ReviewRepository reviewRepository;

    // Get all reviews
    @GetMapping
    public List<ReviewDTO> getAllReviews() {
        return reviewService.getAllReviews();
    }

    @GetMapping("/{userId}")
    public ResponseEntity<List<Review>> getReviewsByFlightId(@PathVariable Integer userId) {
        List<Review> reviews = reviewRepository.findByUserId(userId);
        return ResponseEntity.ok(reviews);
    }

    @PostMapping
    public ResponseEntity<Review> submitReview(@RequestBody ReviewDTO dto) {
        Review savedReview = reviewService.submitReview(dto);
        return ResponseEntity.ok(savedReview);
    }

    // Update an existing review
    @PutMapping("/{id}")
    public Review updateReview(@PathVariable("id") Integer reviewID, @RequestBody Review review) {
        return reviewService.updateReview(reviewID, review);
    }

    // Delete a review
    @DeleteMapping("/{id}")
    public void deleteReview(@PathVariable("id") Integer reviewID) {
        reviewService.deleteReview(reviewID);
    }
}
