package com.example.skychasemk.services;

import com.example.skychasemk.dto.ReviewDTO;
import com.example.skychasemk.model.Review;
import com.example.skychasemk.repository.FlightRepository;
import com.example.skychasemk.repository.ReviewRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Service
public class ReviewService {

    @Autowired
    private ReviewRepository reviewRepository;

    @Autowired
    private FlightRepository flightRepository;

    public List<ReviewDTO> getAllReviews(){
        List<Review> reviews = reviewRepository.findAll();
        List<ReviewDTO> reviewDTOs = new ArrayList<>();

        for (Review review : reviews) {
            ReviewDTO dto = new ReviewDTO();
            dto.setReviewID(review.getReviewID());
            dto.setReviewComment(review.getReviewComment());
            dto.setRating(review.getRating());
            dto.setTargetID(review.getTargetID());
            dto.setUserID(review.getUserID());

            flightRepository.findById(Long.valueOf(review.getTargetID())).ifPresent(flight -> {
                dto.setFlightNumber(flight.getFlightNumber());
            });


            reviewDTOs.add(dto);
        }
        return reviewDTOs;
    }

   /* public List<Review> getAllReviews() {
        return reviewRepository.findAll();
    }*/

    public Optional<Review> getReviewById(Integer reviewID) {
        return reviewRepository.findById(reviewID);
    }

    public Review submitReview(ReviewDTO dto) {
        Review review = new Review();
        review.setUserID(dto.getUserID());
        review.setTargetID(dto.getTargetID());
        review.setReviewComment(dto.getReviewComment());
        review.setRating(dto.getRating());
        review.setDate(LocalDate.now());

        return reviewRepository.save(review);
    }

    public Review updateReview(Integer reviewID, Review review) {
        if (reviewRepository.existsById(reviewID)) {
            review.setReviewID(reviewID);
            return reviewRepository.save(review);
        } else {
            throw new RuntimeException("Review not found with id " + reviewID);
        }
    }

    public void deleteReview(Integer reviewID) {
        reviewRepository.deleteById(reviewID);
    }
}

