package com.example.skychasemk.model;

import jakarta.persistence.*;
import lombok.Getter;

import java.time.LocalDate;

@Getter
@Entity
@Table(name="notification")
public class Notification {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "notificationid")

    private Integer notificationID;
    @Column(name = "userid")

    private Integer userId;
    @Column(name = "message")

    private String message;
    @Column(name = "type")

    @Enumerated(EnumType.STRING)
    private Type type;
    @Column(name = "date_sent")

    private LocalDate dateSent;

    public enum Type {
        BOOKING_CONFIRMATION,
        FLIGHT_DELAY,
        GENERAL_UPDATE
    }

    public void setNotificationID(Integer notificationID) {
        this.notificationID = notificationID;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setDateSent(LocalDate dateSent) {
        this.dateSent = dateSent;
    }
}
