package com.example.skychasemk.services;

import com.example.skychasemk.model.Notification;
import com.example.skychasemk.repository.NotificationRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
public class NotificationService {

    @Autowired
    private NotificationRepository notificationRepository;

    public List<Notification> getAllNotifications(Integer userId) {
        return notificationRepository.findByUserId(userId);
    }

    public Notification saveNotification(Notification notification) {
        return notificationRepository.save(notification);
    }

    public Notification updateNotification(Integer notificationID, Notification notification) {
        if (notificationRepository.existsById(notificationID)) {
            notification.setNotificationID(notificationID);
            return notificationRepository.save(notification);
        } else {
            throw new RuntimeException("Notification not found with id " + notificationID);
        }
    }

    public void deleteNotification(Integer notificationID) {
        notificationRepository.deleteById(notificationID);
    }
}

