package com.example.skychasemk.model;

import jakarta.persistence.*;
import lombok.Data;

import java.time.Instant;
import java.time.LocalDate;

@Entity
@Data
@Table(name="application_user")
public class ApplicationUser {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "userid")

    private Long userid;
    @Column(name = "name")

    private String name;
    @Column(name = "surname")

    private String surname;

    @Column(name="email")
    private String email;
    @Column(name = "password")

    private String password;
    @Column(name = "phone_number")

    private String phone_number;

    @Column(name = "date_joined")
    private LocalDate dateJoined;

    @PrePersist
    protected void onCreate() {
        this.dateJoined = LocalDate.now();
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phone_number = phoneNumber;
    }
}
