package com.example.skychasemk.repository;

import com.example.skychasemk.model.ApplicationUser;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Optional;

@Repository
public interface ApplicationUserRepository extends JpaRepository<ApplicationUser, Long> {
    @Query("SELECT u FROM ApplicationUser u WHERE u.userid = :id")
    Optional<ApplicationUser> getUserById(@Param("id") Long userid);
    @Query("SELECT u FROM ApplicationUser  u WHERE u.email=:email")
    Optional<ApplicationUser> findByEmail(@Param("email") String email);
}