package com.example.skychasemk.controller;

import com.example.skychasemk.dto.ApplicationUserDTO;
import com.example.skychasemk.dto.ApplicationUserLoginDTO;
import com.example.skychasemk.model.ApplicationUser;
import com.example.skychasemk.services.ApplicationUserService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/api/user")
@CrossOrigin(origins = "http://localhost:5173") // Allow frontend access
public class ApplicationUserController {

    @Autowired
    private ApplicationUserService userService;

    @PostMapping("/signup")
    public ResponseEntity<String> registerUser(@Valid @RequestBody ApplicationUserDTO userDTO) {
        ApplicationUser savedUser = userService.registerUser(userDTO);
        return ResponseEntity.ok("User saved successfully");
    }
    @PostMapping("/login")
    public ResponseEntity<Map<String,Long>> loginUser(@Valid @RequestBody ApplicationUserLoginDTO userDTO) {
        ApplicationUser loginUser = userService.findByEmail(userDTO);
        Map<String,Long> response = new HashMap<>();
        response.put("userId",loginUser.getUserid());
        return ResponseEntity.ok(response);
    }
}