package com.example.skychasemk.services;

import com.example.skychasemk.dto.ApplicationUserDTO;
import com.example.skychasemk.dto.ApplicationUserLoginDTO;
import com.example.skychasemk.model.ApplicationUser;
import com.example.skychasemk.repository.ApplicationUserRepository;
import jakarta.transaction.Transactional;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Optional;
//import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;


@Service
public class ApplicationUserService {

    @Autowired
    private ApplicationUserRepository userRepository;

    //private final BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();

    @Transactional
    public ApplicationUser registerUser(ApplicationUserDTO userDTO) {
        if (userRepository.findByEmail(userDTO.getEmail()).isPresent()) {
            throw new RuntimeException("Email already registered");
        }

        ApplicationUser user = new ApplicationUser();
        user.setName(userDTO.getName());
        user.setSurname(userDTO.getSurname());
        user.setEmail(userDTO.getEmail());
        user.setPassword(userDTO.getPassword());
        user.setPhoneNumber(userDTO.getPhone_number());
        ApplicationUser savedUser = userRepository.save(user);
        userRepository.flush();
        return savedUser;
    }

    public ApplicationUser findByEmail(@Valid ApplicationUserLoginDTO userDTO) {
        if (userRepository.findByEmail(userDTO.getEmail()).isEmpty()) {
            throw new RuntimeException("User not registered");
        } else {
            Optional<ApplicationUser> userId = userRepository.findByEmail(userDTO.getEmail());
            return userId.get();
        }
    }
}