package com.example.skychasemk.controller;

import com.example.skychasemk.model.TopMonthlyReport;
import com.example.skychasemk.services.TopMonthlyReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDate;
import java.util.List;

@RestController
@RequestMapping("/api/reports")
@CrossOrigin("*")
public class TopMonthlyReportController {
    @Autowired
    private TopMonthlyReportService service;
    @GetMapping
    public String getReportsPage() {
        return "TopMonthlyReport";
    }

    @GetMapping("/top-monthly")
    public List<TopMonthlyReport> getAllReports() {
        return service.getAllReports();
    }

    @GetMapping("/top-monthly/{month}")
    public List<TopMonthlyReport> getReportsByMonth(@PathVariable String month) {
        return service.getReportsByMonth(LocalDate.parse(month));
    }
}
