package com.example.skychasemk.controller;

import com.example.skychasemk.dto.ApplicationUserDTO;
import com.example.skychasemk.dto.ApplicationUserLoginDTO;
import com.example.skychasemk.model.ApplicationUser;
import com.example.skychasemk.services.ApplicationUserService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/api/user")
@CrossOrigin(origins = "http://localhost:5173")
public class ApplicationUserController {
    @Autowired
    private ApplicationUserService userService;

    @PostMapping("/signup")
    public ResponseEntity<String> registerUser(@Valid @RequestBody ApplicationUserDTO userDTO) {
        try {
            userService.registerUser(userDTO);
            return ResponseEntity.ok("User saved successfully");
        } catch (RuntimeException e) {
            return ResponseEntity.badRequest().body(e.getMessage());
        }
    }


    @PostMapping("/login")
    public ResponseEntity<Map<String, Object>> loginUser(@Valid @RequestBody ApplicationUserLoginDTO loginDTO) {
        Map<String, Object> response = new HashMap<>();
        try {
            ApplicationUser user = userService.loginUser(loginDTO);
            response.put("userId", user.getUserId());
            response.put("name", user.getName());
            return ResponseEntity.ok(response);
        } catch (RuntimeException e) {
            response.put("error", e.getMessage());
            return ResponseEntity.status(401).body(response);
        }
    }

}
